/* ************************************************************************** */
/** Descriptive File Name

  @Company
    Company Name

  @File Name
    filename.h

  @Summary
    Brief description of the file.

  @Description
    Describe the purpose of this file.
 */
/* ************************************************************************** */

#ifndef _EXAMPLE_FILE_NAME_H    /* Guard against multiple inclusion */
#define _EXAMPLE_FILE_NAME_H


/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */

/* This lists the other files that are included in this file.
 */

/* TODO:  Include other files here if needed. */


/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

#define Splash_String_0  (unsigned char *)"  Silicon Chip  "
#define Splash_String_1  (unsigned char *)" Digital Preamp "
#define Blank            (const char *)"                "

#define Splash_Time_ms 1500

/* Interface Related Defines */
#define ROTB !ROT_ENC_1_Get()                       /* pora B bit 7 */
#define ROTA !ROT_ENC_2_Get()                       /* pora B bit 5 */
#define Enter_Key_Pressed !ROT_ENC_SEL_Get()        /* pora B bit 3 */
#define Exit_Key_Pressed !ROT_ENC_EXIT_Get()        /* pora A bit 9 */
#define Input_Select_Up_Key !Input_Sel_Up_Get()     /* Port C bit 8 */
#define Input_Select_Down_Key !Input_Sel_Dn_Get()   /* Port C bit 9 */
#define IR_IN !IR_RX_Get()                          /* port C bit 7 */
#define PortB_Bits ((1<<5) + (1<<7))                /* sorry hard coded the port bits */
#define PortC_Bits ((1<<9) + (1<<8) + (1<<7))       /* Sorry - hard coded the port C bits */    
#define ROT_A (1<<5)                                /* sorry hard coded the port bits */
#define ROT_B (1<<7)                                /* sorry hard coded the port bits */
    
/* Rotary Encoder Stuff */
#define ROTARY_ENC_SETTLE 500 /* 500us */
#define Phase0 (ROT_A + ROT_B)
#define Phase1 (ROT_A)
#define Phase2 (00)
#define Phase3 (ROT_B)
#define KeyPressed (Enter_Key_Pressed || Exit_Key_Pressed ||ROTB || ROTA || IR_IN || Input_Select_Up_Key || Input_Select_Down_Key )
#define Bad_News_Time                    3000 //Make user look at the bad news for 3 seconds
#define Stored_Data_Read_Error_0         (const char *)"Data read error "
#define Stored_Data_Read_Error_1         (const char *)"Using defaults  "
#define SPI_Error_1                      (const char *)"TGM Says: Oops  "
#define SPI_Error_2                      (const char *)"SPI Read Error  "

/* IR Stuff */
#define No_Action 0
#define Volume_Up 1
#define Volume_Down 2
#define Volume_Mute 3
#define Volume_Up_IR 16     /* volume up philips command */
#define Volume_Down_IR 17   /* volume down philips command */
#define Volume_Mute_IR 13   /* Mute philips command */
#define Preamp_Up_Input_IR 32     /* volume up philips command */
#define Preamp_Down_Input_IR 33   /* volume down philips command */
#define Volume_Address_IR 0
#define Volume_Address_IR_RCVR 16
#define RC5_Bits 14         /* this is the total number of bits */    
#define TimerMax 0xFFFF
/*******************************************************************************/
/* Core Timer Clock rate = 24,000,000                                                */
//  RC5 bit period = 1778us
//  RC5 High time  = 889us
//
//  RC5_Short_Short 600 us
//  RC5_Short_Long 1333 us
//  RC5_Long_Short 1334 us
//  RC5_Long_Long  2222 ss
/*******************************************************************************/
#define RC5_Short_Short 700
#define RC5_Short_Long 1333
#define RC5_Long_Short 1334
#define RC5_Long_Long  2222
//#define S1_IR_Interval_Overflow 1000   /* The bit time is 1778us so low time 730 ish */
//#define S2_IR_Interval_Overflow 1000   /* The bit time is 1778us so to next low 1770 isn*/
//#define S3_IR_Interval_Overflow 3000   /* The bit time is 1778us so to next low 1770 isn*/
#define settle_time_IR_Read     10      /* milliseconds */
#define startup_delay 255
#define mute_delay 250   
#define CoreTimer_To_Us  ((CORE_TIMER_FREQUENCY/1000000))    
    
    
//SPI EEPROM Stuff
#define EEPROM_CHIPSEL_PORT GPIO_PORT_A
#define EEPROM_CHIPSEL_BIT 0x0080
#define CselEEPROM DelayUs(1); SYS_PORTS_Set(PORTS_ID_0, APP_EEPROM_PORT, EEPROM_Select, EEPROM_Select); DelayUs(1);
#define CselClearEEPROM DelayUs(1); SYS_PORTS_Clear(PORTS_ID_0, APP_EEPROM_PORT, EEPROM_Select, EEPROM_Select); DelayUs(1);
#define HoldClearEEPROM DelayUs(1); SYS_PORTS_Set(PORTS_ID_0, APP_EEPROM_PORT, EEPROM_Hold, EEPROM_Hold); DelayUs(1);
#define HoldEEPROM DelayUs(1); SYS_PORTS_Clear(PORTS_ID_0, APP_EEPROM_PORT, EEPROM_Hold, EEPROM_Hold); DelayUs(1);
#define EEPROM_INIT_DELAY 10
#define EEPROM_Sel_Delay 2
    
// Some RESET stuff
#define  RESET_DSP_Subsys SYS_RESET_Clear()
#define  CLR_RESET_DSP_Subsys SYS_RESET_Set()
#define  Delay_For_Reset_Ms  10   // this is an aeon in terms of reset times
#define  Delay_For_Reset_Settle_Ms  20   // this is an aeon in terms of reset times
// NOT USED #define DAC_MUTED DAC_Mute_Set()   
// NOT USED #define DAC_UNMUTED DAC_Mute_Clear()   
#define Clear_Analog_SW Input_4_Sel_Clear(); Input_3_Sel_Clear(); Input_2_Sel_Clear(); Input_1_Sel_Clear(); TOSLINK_SEL_Set();
#define Aux2_Sel_Switch Input_4_Sel_Set(); Input_3_Sel_Clear(); Input_2_Sel_Clear(); Input_1_Sel_Clear(); TOSLINK_SEL_Set();
#define Aux1_Sel_Switch Input_4_Sel_Clear(); Input_3_Sel_Set(); Input_2_Sel_Clear(); Input_1_Sel_Clear(); TOSLINK_SEL_Set();
#define Tuner_Sel_Switch Input_4_Sel_Clear(); Input_3_Sel_Clear(); Input_2_Sel_Set(); Input_1_Sel_Clear(); TOSLINK_SEL_Set();
#define Bluetooth_Sel_Switch Input_4_Sel_Clear(); Input_3_Sel_Clear(); Input_2_Sel_Clear(); Input_1_Sel_Set(); TOSLINK_SEL_Set();
    
    
 // Some   ADAU SPI stuff
#define ADAU_SS_Disable ADAU1467_CE_Set();
#define ADAU_SS_Enable ADAU1467_CE_Clear();
#define ADAU_SS_Delay_Boot 11
#define ADAU_SPI_Read_Addr 1
#define ADAU_SPI_Write_Addr 0
#define More_Than_1_Audio_Frame_uS 100  // this is woerst case for 48khz 
#define Block_Write_Delay_Between_Words_uS 3  // this seems a lot more sensible    
#define ADAU1467_Safeload_Base_Parameter MOD_SAFELOADMODULE_DATA_SAFELOAD0_ADDR  //This is compile dependant!!!
#define ADAU_Loading_Delay_ms     10   //the code generated byu sigma studio looks really funky here    
#define ADAU_SR 192000 //this is the ADAU sample rate 
    
/* #defines for inputs */
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_to_MCH_STREAMER 0
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_to_SPDIF 4
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_to_ADC 2

#define INPUT_SEL_MCH_SPDIF_ADC_to_MCH_STREAMER 0
#define INPUT_SEL_MCH_SPDIF_ADC_to_SPDIF 4
#define INPUT_SEL_MCH_SPDIF_ADC_to_ADC 2
    
#define MON_INPUT_SEL_MCH_SPDIF_ADC_to_SPDIF 0
#define MON_INPUT_SEL_MCH_SPDIF_ADC_to_ADC 2

#define ADAU_Select_MCH_In     SIGMA_WRITE_SINGLE_REGISTER(ADAU_SPI_Write_Addr, MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_ADDR, NumBytes_Word_Parms_SW, INPUT_SEL_MCH_SPDIF_ADC_to_MCH_STREAMER)
#define ADAU_Select_SPDIF_In     SIGMA_WRITE_SINGLE_REGISTER(ADAU_SPI_Write_Addr, MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_ADDR, NumBytes_Word_Parms_SW, INPUT_SEL_MCH_SPDIF_ADC_to_SPDIF)
#define ADAU_Select_ADC_In     SIGMA_WRITE_SINGLE_REGISTER(ADAU_SPI_Write_Addr, MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_ADDR, NumBytes_Word_Parms_SW, INPUT_SEL_MCH_SPDIF_ADC_to_ADC)
    
#define ADAU_MON_Select_SPDIF_In     SIGMA_WRITE_SINGLE_REGISTER(ADAU_SPI_Write_Addr, MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_ADDR, NumBytes_Word_Parms_SW, MON_INPUT_SEL_MCH_SPDIF_ADC_to_SPDIF)
#define ADAU_MON_Select_ADC_In     SIGMA_WRITE_SINGLE_REGISTER(ADAU_SPI_Write_Addr, MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_ADDR, NumBytes_Word_Parms_SW, MON_INPUT_SEL_MCH_SPDIF_ADC_to_ADC)
    
    
// *****************************************************************************
// *****************************************************************************
/* Application states
  Summary:
  The first set are Application states enumeration
  Description:
    This enumeration defines the valid application states.  These states
    determine the behavior of the application at various times.
*/
// *****************************************************************************
// *****************************************************************************
typedef enum
{
	/* Application's state machine's initial state. */
	Digital_Preamp_STATE_INIT=0,
	Digital_Preamp_STATE_LCDINIT,
    Digital_Preamp_STATE_IDLE,
    Digital_Preamp_STATE_SETTINGS,
    Digital_Preamp_STATE_LOAD,        
    Digital_Preamp_STATE_SAVE,
    Digital_Preamp_STATE_Monitor_Setup,
    Digital_Preamp_STATE_Channel_Setup,
    Digital_Preamp_STATE_Channel_Update,
    Digital_Preamp_STATE_EQ_Setup,
    Digital_Preamp_STATE_EQ_Update

} Digital_Preamp_STATES;

// *****************************************************************************
/* Application Data

  Summary:
    Holds Low_Ohms application action data

  Remarks:
    Application strings and buffers are be defined outside this structure. */
typedef enum
{
	/* Application's state machine's initial state. */
	Digital_Preamp_ACTION_INIT=0,
    Digital_Preamp_LOAD,
    Digital_Preamp_SAVE,
    Digital_Preamp_IDLE,
    Digital_Preamp_Monitor_Setup,
    Digital_Preamp_Channel_Setup,
    Digital_Preamp_EQ_Setup
} Setting_ACTIONS;


/* User Interface Actions*/
typedef enum
{
	/* Application's state machine's initial state. */
	UIAction_NULL = 0,
	UIAction_ROT_Up,            
	UIAction_ROT_Down,
   	UIAction_ROT_Enter,
   	UIAction_ROT_Exit,
   	UIAction_Input_Up,
   	UIAction_Input_Down,
    UIAction_Input_Mute
} UI_ACTIONS;

/* Use to define input selects */
typedef enum
{
	Input_Null = 0,
	Input_MiniDSP,
	Input_SPDIF_Coax,
	Input_SPDIF_TOSLINK,
	Input_AUX2,
	Input_AUX1,
	Input_Tuner,
	Input_Bluetooth
} Digital_Preamp_INPUTS;


/* Use to define crossover slope types */
typedef enum
{
	NoFilter = 0,
    SixdB,
	TwelvedB,
	TwentyFourdB,
	FortyEightdB           
} Digital_Preamp_Slopes;

/* Used to track which parameter for each band we are looking at */
typedef enum{
		Sel_Sl,
		Sel_Fl,
		Sel_Su,
		Sel_Fu,
        Sel_Atten,
		Sel_Delay_mm,
		Sel_Invert,
        Sel_Bridge
}  Channel_Parameter_sel ;

/* USed to define the crossover parameters for each of four bands */
typedef struct{
		int Fl;
		int Fu;
		int Sl;
		int Su;
        int Atten;   /* in half dB steps */
		int Delay_mm;
		int Invert;
        int Bridge;
}  data_val_struct ;

/* Identify the EQ type to be used */
typedef enum
{
	EQ_TYPE_NONE= 0x10,
    EQ_TYPE_PARA = 0x11,
} EQ_TYPES;


/* Used to define the parametric EQ characteristics for  */
/* The common parametric EQ's that are applied at the input to the preamp */
/* and those applied to each band only */
typedef struct{
		int CF;
		int Q;
		int Gain;
		EQ_TYPES Type;
        int HF_Gain;
}  Para_EQ_struct ;

typedef enum{
		Sel_CF,
		Sel_Q,
		Sel_Gain,
		Sel_Type,
        Sel_HF_Gain,
}  EQ_Parameter_sel;

/* IR States */
typedef enum
{
	/* Application's state machine's initial state. */
	Out_1 = 0,   // "1" received, input is low
    Mid_Out_1=1,
    Out_0=2,       //"0" received, input is high
    Mid_Out_0=3,
            
	/* TODO: Define states used by the application state machine. */
} RC5_STATES;



// *****************************************************************************
/* Application Data

  Summary:
    Holds Digital_Preamp application data

  Remarks:
    Application strings and buffers are defined outside this structure.
 */
// *****************************************************************************
// *****************************************************************************

typedef struct
{
    /* The application's current state */
    Digital_Preamp_STATES       state;                  /* UI driver timer handle. */
    int                         UI_Fast_Count;          /* UI fast count. */
    int                         UI_Slow_Count;          /* UI slow count. */
    int                         UI_Update_Counter;      /* UI update count. */
    int                         UI_Speed;               /* use fast or slow */
    int                         UI_CurrentPortB;        /* Used to store current portB state */
    int                         UI_TempPortB;           /* Used to store current portB state */
    int                         UI_CurrentPortC;        /* Used to store current portC state */
    int                         UI_TempPortC;           /* Used to store current portC state */
    int                         heartbeatToggle;        /* Flag for heartbeat */
    int                         Revert_To_Idle_Counter; /* used as flag for reverting state to idle */
    long int                    Number_Of_Writes;       /* UI fast count. */
    int                         UI_Update_Display;      /* UI needs update */
    int                         UI_Update_Display_Delay;/* how long we want to delay after writing the display */
    long int                    UI_Keypressed;          /* UI action */
    long int                    UI_Keypressed_Enter;    /* UI action Enter*/
    long int                    UI_Keypressed_Select;   /* UI Action Select */
    long int                    UI_Input_Select_Up;     /* UI keypress for input up */
    long int                    UI_Input_Select_Down;   /* UI keypress for input down */
    UI_ACTIONS                  UI_Action;              /* Capture what the user wants to do. */
    Setting_ACTIONS             Settings;               /* Select setting to mod */
    int                         Atten_Set;              /* Overall attenuation to apply: positive = atten, negative = gain*/ 
    Digital_Preamp_INPUTS       Input_Sel;              /* List of inputs that may be selected */
    Digital_Preamp_INPUTS       Monitor_Sel;            /* when MinidSP is being used we can select an ADC input to monitor on the MiniDSP output */
    data_val_struct             Data_Values[4];         /* Data Values for XO*/
    int                         Channel_Selected;       /* Channel we are currently using */
    Channel_Parameter_sel       Channel_Parm_Selected;  /* Channel Parameter Selected */
    Para_EQ_struct              EQ_Values[16];	        /* Parametrc filter values 4 common filter sets, plus 3 per band */
    int                         EQ_Selected;            /* EQ we are currently using */
    EQ_Parameter_sel            EQ_Parm_Selected;       /* EQ Parameter Selected */
    int                         Timer_Time;             /* used for IR RX */
    int                         Timer_Temp;             /* used for IR RX */
    int                         Time_Out;               /* used for IR RX */
    int                         ROT_State;              /* used for rotary encoder */
    int                         ROT_State_Prev;         /* used for rotary encoder */
    RC5_STATES                  IR_State;               /* used for IR RX */
    int                         IR_RX;                  /* used for IR RX */
    int                         IR_Addr;                /* IR RX address  - usually TV or RCVR */
    int                         IR_Current_Port;        /* used for IR RX */
    int                         IR_Temp_Port;           /* used for IR RX */
    unsigned int                Interval;               /* used for IR RX */
    int                         IR_Toggle;              /* toggle bit in IR */
    int                         IR_Address;             /* IR Address Received */
    int                         IR_Command;             /* IR command Received */
    int                         Output_Mute;            /* Mute system */
    int                         TEMP_DATA;              /* scratch */
    int                         MemoryBankSelected;     /* Will have several memory Banks available when you finish this ;) */
 
} Digital_Preamp_DATA;


/*************************************/
/* LIMITS - For Digital Preamp       */
/*************************************/
#define Min_XO_Band                 0
#define Max_XO_Band                 3 /* always load and store the four bands */
#define Min_EQ_Band                 0  /* A bit handraulic - 3 common plus 3 per channel*/
#define Max_EQ_Band                 14 /* this is MAx... */
#define Gen1_Para_data              0 
#define Gen2_Para_data              1 
#define Gen3_Para_data              2 
#define Min_Common_EQ               Min_EQ_Band  /* there are 4 total */
#define Max_Common_EQ               2  /* there are 3 total - remember this starts at zero*/
#define Max_EQ_Per_Channel          2  /* Remeber this is +1 = "3" per ADAU file*/
#define Num_Bands_Of_EQ             Max_XO_Band  /* The number of mbands in total */

/***************************************************/
/* Storage related in the hardware implementation  */
/* Stuff to allow memory bank in use to be tracked */
/***************************************************/
#define Mem_Banks_Do_Not_Erase      3
#define Mem_Banks_Erase             4
#define Max_Mem_Banks_With_Erase    4
#define Max_Mem_Banks               2
#define Default_Mem_Bank            0
#define Clear_Buffers_SPI_Time      3

/* How big is each set of data in ROM?*/
#define ParmSet_Array_Size          0x0800
/* Approx EEPROM write delay in mS */
#define EEPROM_WR_Delay             10   
/* Approx EEPROM write delay in mS */
#define DAC_RESET_Delay             50   

/* These offsets are within each band block */
#define Fl_Offset                   0X0000
#define Fu_Offset                   0X0004
#define Sl_Offset                   0X0008
#define Su_Offset                   0X000C
#define Atten_Offset                0X0010
#define Delay_mm_Offset             0X0014
#define Invert_Offset               0X0048
#define Bridge_Offset               0X004C
#define Channel_Set_Array_Size      0x0080

#define Para_Gen_Base               0x0200
#define Para_Set_Size               0x0040

#define Para_CF_Offset              0x0000
#define Para_Q_Offset               0x0004
#define Para_Gain_Offset            0x0008
#define Para_Type_Offset            0x000c
#define Para_HF_Offset              0x0010    //only used on Gen 0 for tone


#define Input_Selected_Offset       0x01F8
#define Volume_Offset               0x01F4
#define Monitor_Offset              0x01F0

#define ScratchPad_Offset            0x0040

/*  Limit Values for Data Structures  */
#define Tone_Gain_Step_Size           1 //dB
#define EQ_Gain_Step_Size           1 //dB
#define	EQ_Min 10
#define	EQ_Gain_Max 10              /* dB */
#define	EQ_Gain_Min -10             /* dB */
#define	EQ_Q_Max 100                /* times 10 */
#define	EQ_Q_Min 1                  /* times 10 */
#define EQ_Q_Step 1                 /* unit of 1 */
#define	EQ_Max 20000                /* Hz */
#define EQ_Step 1                   /* Hz */
#define	Fl_Min 5                    /* Hz */
#define Fl_Step 1                   /* Hz */
#define	Fl_Max 20000                /* Hz */
#define	Fu_Min 10                   /* Hz */
#define Fu_Step 1                   /* Hz */
#define	Fu_Max 20000                /* Hz */
#define Sl_Step 1
#define	Sl_Min NoFilter    /* Sl = 0, None */
				    /* Sl = 1, 6dB Slope */
				    /* Sl = 2, 12dB Slope */
				    /* Sl = 3, LR24 Slope */
				    /* Sl = 4, LR48 Slope */
#define	Sl_Max FortyEightdB    /* LR 24 Slope */
#define Su_Step 1
#define	Su_Min NoFilter    /* Sl = 0, None */
				    /* Sl = 1, 6dB Slope */
				    /* Sl = 2, 12dB Slope */
				    /* Sl = 3, LR24 Slope */
				    /* Sl = 4, LR48 Slope */
#define	Su_Max FortyEightdB    /* LR 24 Slope */
#define	Delay_mm_Min 1
/* Note this maximum is determined by the RAM allocated in the DSP */
/* Current allocation is 4096 samples, or 7279mm odd at C=341210mm/s */
/* This parameter = (4096 / Sample_Rate)*Speed_Of_Sound_in_air */
#define SpeedOfSound 341210   /* millimetres per second */

#define Delay_Step 1
#define	Delay_Min 1
#define	Delay_Max 4096
#define	Delay_mm_Max 7279
#define Invert_True 1
#define Invert_False 0
#define Bridge_True 1
#define Bridge_False 0
#define Atten_On_Loading_Min (unsigned char)80
#define	Gain_Atten_Min (unsigned char) 0     /*steps of 0.5dB */
#define	Gain_Atten_Max (unsigned char) 40    /*steps of 0.5dB */
/* Attenuation to use for mute in dB */
#define	Atten_Speed          6     /* lots of 0.5dB Seems like a sensible number*/
#define Atten_Step           1     /* step of 0.5dB */
#define	Atten_Min            -24     /* Seems like a sensible number*/
#define	Atten_Max            (104*2) /* half dB's Seems like a sensible number*/
#define Atten_Default        66 

#define  Mute 255
/* Can't believe I have to define this!!! */
#define Pi (double) 3.141592653590
#define sqrt2 (double) 1.414213562373



/***************************************************/
//  User interface behaviour control
// These define how long before increments on the rotary encoder go from
// "slow increments" to fast increments
// then how lond before "fast" reverts to "slow" again
/***************************************************/
#define debounce_time_us 3000
#define Speed_Init     1
#define Revert_To_Idle 6660000    /* About 10s delay before retuirns to idle */
#define Key_Press_Delay_Us 150
#define UI_Delay_Ms_Inputs 250
#define UI_Delay_Ms_Mute_Time 1000
#define UI_Delay_Ms_Volume 50
#define UI_Delay_Ms_General 50
#define UI_Delay_Ms_Mute 200
#define UI_Delay_Ms_Exit 250
#define UI_Delay_Ms_Load 250


#define Slow_Counter_Init 500000
#define Fast_Counter_Init 10
#define Delay_After_Save_Ms    500
//#define	Temp_Normal_Speed   1     /* Seems like a sensible number*/
//#define	Temp_Speed          10     /* Seems like a sensible number*/
#define Clear_UI_Input PreampData.UI_Action = UIAction_NULL; PreampData.UI_Keypressed = false
#define Disable_Interrupts_During_Proc     GPIO_PinInterruptDisable(GPIO_PIN_RC7); TMR1_InterruptDisable();
#define Re_enable_Interrupts               GPIO_PinInterruptEnable(GPIO_PIN_RC7); TMR1_InterruptEnable();


/******************************************************************************/
// Values and limits for the application  
/******************************************************************************/    
//#define	Revert_To_Idle      (45 * Snooze_Counts_PerSec)   /* Seems like a sensible number*/
#define	Snooze_Min          (30 * Snooze_Counts_PerSec)   /* Seems like a sensible number*/
#define	Snooze_Max          (3600 * Snooze_Counts_PerSec) /* An hour Seems like a sensible number*/
#define	Snooze_Default      (600  * Snooze_Counts_PerSec)
#define Snooze_Counts_PerSec 2   /* This should be defined by the ISR Call Rate */


void UI_InterruptHandler(uint32_t intCause, uintptr_t context);
void LCD_Boot(void);
void LCD_Splash_Screen(void);
void Digital_Preamp_Tasks(void);


    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _EXAMPLE_FILE_NAME_H */

/* *****************************************************************************
 End of File
 */
